/*
 * Decompiled with CFR 0.152.
 */
package com.android.chileaf;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGatt;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattService;
import android.bluetooth.BluetoothManager;
import android.content.Context;
import android.os.ParcelUuid;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.android.chileaf.external.NotificationSpec;
import com.android.chileaf.external.PhoneCallSpec;
import com.android.chileaf.external.SpecManager;
import com.android.chileaf.fitness.FitnessManager;
import com.android.chileaf.fitness.callback.AccelerometerCallback;
import com.android.chileaf.fitness.callback.BindDeviceCallback;
import com.android.chileaf.fitness.callback.BloodOxygenCallback;
import com.android.chileaf.fitness.callback.BluetoothStatusCallback;
import com.android.chileaf.fitness.callback.BodySportCallback;
import com.android.chileaf.fitness.callback.CustomDataReceivedCallback;
import com.android.chileaf.fitness.callback.FilterScanCallback;
import com.android.chileaf.fitness.callback.HeartRateMaxCallback;
import com.android.chileaf.fitness.callback.HeartRateThroughoutTheDayCallback;
import com.android.chileaf.fitness.callback.HistoryBloodOxygenCallback;
import com.android.chileaf.fitness.callback.HistoryBodyTemperatureCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDetailDataCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRDetailRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfHRRecordCallback;
import com.android.chileaf.fitness.callback.HistoryOfHealthDataCallback;
import com.android.chileaf.fitness.callback.HistorySevenDaysOfSportsCallback;
import com.android.chileaf.fitness.callback.HistorySkippingRopeCallback;
import com.android.chileaf.fitness.callback.HistorySleepCallback;
import com.android.chileaf.fitness.callback.HistorySportsCallback;
import com.android.chileaf.fitness.callback.IntervalStepCallback;
import com.android.chileaf.fitness.callback.MACAddressCallback;
import com.android.chileaf.fitness.callback.MeasureModeStateCallback;
import com.android.chileaf.fitness.callback.PhysicalConditionCallback;
import com.android.chileaf.fitness.callback.RespiratoryRateCallback;
import com.android.chileaf.fitness.callback.SensorRawDataCallback;
import com.android.chileaf.fitness.callback.SingleTapRecordCallback;
import com.android.chileaf.fitness.callback.SkippingRopeDataCallback;
import com.android.chileaf.fitness.callback.SpecificFunctionCallback;
import com.android.chileaf.fitness.callback.SportModeCallback;
import com.android.chileaf.fitness.callback.SportModeExitStatusCallback;
import com.android.chileaf.fitness.callback.SportsRealTimeDataCallback;
import com.android.chileaf.fitness.callback.TemperatureCallback;
import com.android.chileaf.fitness.callback.UserIdNameCallback;
import com.android.chileaf.fitness.callback.UserInfoCallback;
import com.android.chileaf.fitness.callback.VibrationIntensityCallback;
import com.android.chileaf.fitness.callback.WashHandsCallback;
import com.android.chileaf.fitness.callback.WearManagerCallbacks;
import com.android.chileaf.fitness.callback.WearReceivedCallback;
import com.android.chileaf.fitness.callback.WeatherStatusCallback;
import com.android.chileaf.fitness.common.heart.BodySensorLocationDataCallback;
import com.android.chileaf.fitness.common.heart.HeartRateMeasurementCallback;
import com.android.chileaf.fitness.common.heart.HeartRateMeasurementDataCallback;
import com.android.chileaf.fitness.common.parser.BodySensorLocationParser;
import com.android.chileaf.fitness.common.parser.HeartRateMeasurementParser;
import com.android.chileaf.model.BloodOxygenHistory;
import com.android.chileaf.model.BodyTemperatureHistory;
import com.android.chileaf.model.HeartRateAllDay;
import com.android.chileaf.model.HistoryOfHealth;
import com.android.chileaf.model.HistoryOfHeartRate;
import com.android.chileaf.model.HistoryOfHeartRateDetail;
import com.android.chileaf.model.HistoryOfHeartRateDetailRecord;
import com.android.chileaf.model.HistorySevenDaysOfSports;
import com.android.chileaf.model.HistorySkippingRope;
import com.android.chileaf.model.HistorySleep;
import com.android.chileaf.model.HistorySports;
import com.android.chileaf.model.IntervalStep;
import com.android.chileaf.util.DateUtil;
import com.android.chileaf.util.HexUtil;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import no.nordicsemi.android.ble.BleManager;
import no.nordicsemi.android.ble.data.Data;
import no.nordicsemi.android.support.v18.scanner.BluetoothLeScannerCompat;
import no.nordicsemi.android.support.v18.scanner.ScanCallback;
import no.nordicsemi.android.support.v18.scanner.ScanFilter;
import no.nordicsemi.android.support.v18.scanner.ScanResult;
import no.nordicsemi.android.support.v18.scanner.ScanSettings;

@SuppressLint(value={"MissingPermission"})
public class WearManager
extends FitnessManager<WearManagerCallbacks> {
    private static final UUID HR_SERVICE_UUID = UUID.fromString("0000180D-0000-1000-8000-00805f9b34fb");
    private static final UUID BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID = UUID.fromString("00002A38-0000-1000-8000-00805f9b34fb");
    private static final UUID HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID = UUID.fromString("00002A37-0000-1000-8000-00805f9b34fb");
    private static WearManager mInstance = null;
    private String[] mFilterNames = null;
    private WearScanCallback mScanCallback;
    private BluetoothGattCharacteristic mBodySensorLocationCharacteristic;
    private BluetoothGattCharacteristic mHeartRateCharacteristic;
    private UserInfoCallback mUserInfoCallback;
    private BodySportCallback mBodySportCallback;
    private HeartRateMeasurementCallback mHeartRateMeasurementCallback;
    private HistorySevenDaysOfSportsCallback mHistorySevenDaysOfSportsCallback;
    private HistoryOfHRRecordCallback mHistoryOfHRRecordCallback;
    private HistoryOfHRDataCallback mHistoryOfHRDataCallback;
    private IntervalStepCallback mIntervalStepsCallback;
    private SingleTapRecordCallback mSingleTapRecordCallback;
    private BluetoothStatusCallback mBluetoothStatusCallback;
    private CustomDataReceivedCallback mCustomDataReceivedCallback;
    private HistorySleepCallback historySleepCallback;
    private WashHandsCallback washHandsCallback;
    private BloodOxygenCallback bloodOxygenCallback;
    private TemperatureCallback mTemperatureCallback;
    private VibrationIntensityCallback mVibrationIntensityCallback;
    private SportModeCallback mSportModeCallback;
    private WeatherStatusCallback mWeatherStatusCallback;
    private HistoryBodyTemperatureCallback mHistoryBodyTemperatureCallback;
    private HistoryBloodOxygenCallback mHistoryBloodOxygenCallback;
    private HistorySportsCallback mHistorySportsCallback;
    private BindDeviceCallback mBindDeviceCallback;
    private SpecificFunctionCallback mSpecificFunctionCallback;
    private SkippingRopeDataCallback mSkippingRopeDataCallback;
    private HistorySkippingRopeCallback mHistorySkippingRopeCallback;
    private HeartRateThroughoutTheDayCallback mHeartRateThroughoutTheDayCallback;
    private SportsRealTimeDataCallback mSportsRealTimeDataCallback;
    private AccelerometerCallback mAccelerometerCallback;
    private PhysicalConditionCallback mPhysicalConditionCallback;
    private SportModeExitStatusCallback mSportModeExitStatusCallback;
    private SensorRawDataCallback mSensorRawDataCallback;
    private MACAddressCallback mMacAddressCallback;
    private HistoryOfHealthDataCallback mHistoryOfHealthDataCallback;
    private UserIdNameCallback mUserIdNameCallback;
    private MeasureModeStateCallback mMeasureModeStateCallback;
    private RespiratoryRateCallback mRespiratoryRateCallback;
    private HistoryOfHRDetailRecordCallback mHistoryOfHRDetailRecordCallback;
    private HistoryOfHRDetailDataCallback mHistoryOfHRDetailDataCallback;
    private HeartRateMaxCallback mHeartRateMaxCallback;
    private final BodySensorLocationDataCallback mBodySensorLocationDataCallback = new BodySensorLocationDataCallback(){

        @Override
        public void onBodySensorLocationReceived(@NonNull BluetoothDevice device, int sensorLocation) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onBodySensorLocationReceived(device, sensorLocation);
        }

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(3, String.format("%s received", BodySensorLocationParser.parse(data)));
            super.onDataReceived(device, data);
        }
    };
    private final HeartRateMeasurementDataCallback mHeartRateMeasureDataCallback = new HeartRateMeasurementDataCallback(){

        @Override
        public void onHeartRateMeasurementReceived(@NonNull BluetoothDevice device, int heartRate, @Nullable Boolean contactDetected, @Nullable Integer energyExpanded, @Nullable List<Integer> rrIntervals) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onHeartRateMeasurementReceived(device, heartRate, contactDetected, energyExpanded, rrIntervals);
            if (WearManager.this.mHeartRateMeasurementCallback != null) {
                WearManager.this.mHeartRateMeasurementCallback.onHeartRateMeasurementReceived(device, heartRate, contactDetected, energyExpanded, rrIntervals);
            }
        }

        @Override
        public void onDataReceived(@NonNull BluetoothDevice device, @NonNull Data data) {
            WearManager.this.log(3, HeartRateMeasurementParser.parse(data) + " received");
            super.onDataReceived(device, data);
        }
    };
    private final WearReceivedCallback mReceivedDataCallback = new WearReceivedCallback(){

        @Override
        public void onHeartRateMaxReceived(@NonNull BluetoothDevice device, int max) {
            if (WearManager.this.mHeartRateMaxCallback != null) {
                WearManager.this.mHeartRateMaxCallback.onHeartRateMaxReceived(device, max);
            }
        }

        @Override
        public void onHistoryOfHRDetailRecordReceived(@NonNull BluetoothDevice device, List<HistoryOfHeartRateDetailRecord> records) {
            if (WearManager.this.mHistoryOfHRDetailRecordCallback != null) {
                WearManager.this.mHistoryOfHRDetailRecordCallback.onHistoryOfHRDetailRecordReceived(device, records);
            }
        }

        @Override
        public void onHistoryOfHRDetailDataReceived(@NonNull BluetoothDevice device, List<HistoryOfHeartRateDetail> heartRates) {
            if (WearManager.this.mHistoryOfHRDetailDataCallback != null) {
                WearManager.this.mHistoryOfHRDetailDataCallback.onHistoryOfHRDetailDataReceived(device, heartRates);
            }
        }

        @Override
        public void onRespiratoryRateReceived(@NonNull BluetoothDevice device, int respiratoryRate) {
            if (WearManager.this.mRespiratoryRateCallback != null) {
                WearManager.this.mRespiratoryRateCallback.onRespiratoryRateReceived(device, respiratoryRate);
            }
        }

        @Override
        public void onMeasureModeStateReceived(@NonNull BluetoothDevice device, int mode, int state) {
            if (WearManager.this.mMeasureModeStateCallback != null) {
                WearManager.this.mMeasureModeStateCallback.onMeasureModeStateReceived(device, mode, state);
            }
        }

        @Override
        public void onUserIdNameReceived(@NonNull BluetoothDevice device, long userId, String name) {
            if (WearManager.this.mUserIdNameCallback != null) {
                WearManager.this.mUserIdNameCallback.onUserIdNameReceived(device, userId, name);
            }
        }

        @Override
        public void onHistoryOfHealthDataStart() {
            if (WearManager.this.mHistoryOfHealthDataCallback != null) {
                WearManager.this.mHistoryOfHealthDataCallback.onHistoryOfHealthDataStart();
            }
        }

        @Override
        public void onHistoryOfHealthDataReceived(@NonNull BluetoothDevice device, int sequence, HistoryOfHealth health) {
            if (WearManager.this.mHistoryOfHealthDataCallback != null) {
                WearManager.this.mHistoryOfHealthDataCallback.onHistoryOfHealthDataReceived(device, sequence, health);
            }
        }

        @Override
        public void onHistoryOfHealthDataComplete() {
            if (WearManager.this.mHistoryOfHealthDataCallback != null) {
                WearManager.this.mHistoryOfHealthDataCallback.onHistoryOfHealthDataComplete();
            }
        }

        @Override
        public void onSensorRawDataReceived(@NonNull BluetoothDevice device, int sequence, int gyrosX, int gyroY, int gyroZ, int accelerometerX, int accelerometerY, int accelerometerZ) {
            if (WearManager.this.mSensorRawDataCallback != null) {
                WearManager.this.mSensorRawDataCallback.onSensorRawDataReceived(device, sequence, gyrosX, gyroY, gyroZ, accelerometerX, accelerometerY, accelerometerZ);
            }
        }

        @Override
        public void onMACAddressReceived(@NonNull BluetoothDevice device, String address) {
            if (WearManager.this.mMacAddressCallback != null) {
                WearManager.this.mMacAddressCallback.onMACAddressReceived(device, address);
            }
        }

        @Override
        public void onSportModeExitStatusReceived(@NonNull BluetoothDevice device, int state) {
            if (WearManager.this.mSportModeExitStatusCallback != null) {
                WearManager.this.mSportModeExitStatusCallback.onSportModeExitStatusReceived(device, state);
            }
        }

        @Override
        public void onPhysicalConditionReceived(@NonNull BluetoothDevice device, int emotion, int fatigue, int pressure) {
            if (WearManager.this.mPhysicalConditionCallback != null) {
                WearManager.this.mPhysicalConditionCallback.onPhysicalConditionReceived(device, emotion, fatigue, pressure);
            }
        }

        @Override
        public void on3DRawDataReceived(@NonNull BluetoothDevice device, int sequence, int ppg, int x, int y, int z) {
            if (WearManager.this.mAccelerometerCallback != null) {
                WearManager.this.mAccelerometerCallback.on3DRawDataReceived(device, sequence, ppg, x, y, z);
            }
        }

        @Override
        public void onSportRealTimeDataReceived(@NonNull BluetoothDevice device, int step, int distance, float calorie, int speed, int cadence, int sportMode, int hour, int minute, int seconds, int maxOxygenUptake, int numberOfBreaths, int emotion, int pressure, int fatigueIndex) {
            if (WearManager.this.mSportsRealTimeDataCallback != null) {
                WearManager.this.mSportsRealTimeDataCallback.onSportRealTimeDataReceived(device, step, distance, calorie, speed, cadence, sportMode, hour, minute, seconds, maxOxygenUptake, numberOfBreaths, emotion, pressure, fatigueIndex);
            }
        }

        @Override
        public void onHeartRateThroughoutTheDayCallbackReceived(@NonNull BluetoothDevice device, List<HeartRateAllDay> heartRateAllDays) {
            if (WearManager.this.mHeartRateThroughoutTheDayCallback != null) {
                WearManager.this.mHeartRateThroughoutTheDayCallback.onHeartRateThroughoutTheDayCallbackReceived(device, heartRateAllDays);
            }
        }

        @Override
        public void onHistorySkippingRopeReceived(@NonNull BluetoothDevice device, List<HistorySkippingRope> skippingRopes) {
            if (WearManager.this.mHistorySkippingRopeCallback != null) {
                WearManager.this.mHistorySkippingRopeCallback.onHistorySkippingRopeReceived(device, skippingRopes);
            }
        }

        @Override
        public void onSkippingRopeDataReceived(@NonNull BluetoothDevice device, int jumpRopeSwitch, long todaySkipCount, long currentSkipCount, float currentSkipCalories, long totalSkipTime, long currentSkipTime) {
            if (WearManager.this.mSkippingRopeDataCallback != null) {
                WearManager.this.mSkippingRopeDataCallback.onSkippingRopeDataReceived(device, jumpRopeSwitch, todaySkipCount, currentSkipCount, currentSkipCalories, totalSkipTime, currentSkipTime);
            }
        }

        @Override
        public void onSpecificFunctionReceived(@NonNull BluetoothDevice device, boolean state) {
            if (WearManager.this.mSpecificFunctionCallback != null) {
                WearManager.this.mSpecificFunctionCallback.onSpecificFunctionReceived(device, state);
            }
        }

        @Override
        public void onBindDeviceReceived(@NonNull BluetoothDevice device, int mode) {
            if (WearManager.this.mBindDeviceCallback != null) {
                WearManager.this.mBindDeviceCallback.onBindDeviceReceived(device, mode);
            }
        }

        @Override
        public void onHistorySportsReceived(@NonNull BluetoothDevice device, List<HistorySports> sports) {
            if (WearManager.this.mHistorySportsCallback != null) {
                WearManager.this.mHistorySportsCallback.onHistorySportsReceived(device, sports);
            }
        }

        @Override
        public void onHistoryBloodOxygenReceived(@NonNull BluetoothDevice device, List<BloodOxygenHistory> bloodOxygenHistories) {
            if (WearManager.this.mHistoryBloodOxygenCallback != null) {
                WearManager.this.mHistoryBloodOxygenCallback.onHistoryBloodOxygenReceived(device, bloodOxygenHistories);
            }
        }

        @Override
        public void onBodyBodyTemperatureHistoryReceived(@NonNull BluetoothDevice device, List<BodyTemperatureHistory> temperatureHistories) {
            if (WearManager.this.mHistoryBodyTemperatureCallback != null) {
                WearManager.this.mHistoryBodyTemperatureCallback.onBodyBodyTemperatureHistoryReceived(device, temperatureHistories);
            }
        }

        @Override
        public void onWeatherStatusReceived(@NonNull BluetoothDevice device, boolean state) {
            if (WearManager.this.mWeatherStatusCallback != null) {
                WearManager.this.mWeatherStatusCallback.onWeatherStatusReceived(device, state);
            }
        }

        @Override
        public void onSportModeReceived(@NonNull BluetoothDevice device, boolean state) {
            if (WearManager.this.mSportModeCallback != null) {
                WearManager.this.mSportModeCallback.onSportModeReceived(device, state);
            }
        }

        @Override
        public void onVibrationIntensityReceived(@NonNull BluetoothDevice device, boolean state) {
            if (WearManager.this.mVibrationIntensityCallback != null) {
                WearManager.this.mVibrationIntensityCallback.onVibrationIntensityReceived(device, state);
            }
        }

        @Override
        public void onTemperatureReceived(@NonNull BluetoothDevice device, float environment, float wrist, float body) {
            if (WearManager.this.mTemperatureCallback != null) {
                WearManager.this.mTemperatureCallback.onTemperatureReceived(device, environment, wrist, body);
            }
        }

        @Override
        public void onBloodOxygenReceived(@NonNull BluetoothDevice device, int mSwitch, String value, int gesture, int piValue, int onwrist) {
            if (WearManager.this.bloodOxygenCallback != null) {
                WearManager.this.bloodOxygenCallback.onBloodOxygenReceived(device, mSwitch, value, gesture, piValue, onwrist);
            }
        }

        @Override
        public void onWashHandsReceived(@NonNull BluetoothDevice device, long count, long count1) {
            if (WearManager.this.washHandsCallback != null) {
                WearManager.this.washHandsCallback.onWashHandsReceived(device, count, count1);
            }
        }

        @Override
        public void onSleepDataReceived(@NonNull BluetoothDevice device, List<HistorySleep> historySleeps) {
            if (WearManager.this.historySleepCallback != null) {
                WearManager.this.historySleepCallback.onSleepDataReceived(device, historySleeps);
            }
        }

        @Override
        public void onSportReceived(@NonNull BluetoothDevice device, int step, int distance, float calorie) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onSportReceived(device, step, distance, calorie);
            if (WearManager.this.mBodySportCallback != null) {
                WearManager.this.mBodySportCallback.onSportReceived(device, step, distance, calorie);
            }
        }

        @Override
        public void onBluetoothStatusReceived(@NonNull BluetoothDevice device, boolean enabled) {
            ((WearManagerCallbacks)WearManager.this.mCallbacks).onBluetoothStatusReceived(device, enabled);
            if (WearManager.this.mBluetoothStatusCallback != null) {
                WearManager.this.mBluetoothStatusCallback.onBluetoothStatusReceived(device, enabled);
            }
        }

        @Override
        public void onUserInfoReceived(@NonNull BluetoothDevice device, int age, int sex, int weight, int height, long userId) {
            if (WearManager.this.mUserInfoCallback != null) {
                WearManager.this.mUserInfoCallback.onUserInfoReceived(device, age, sex, weight, height, userId);
            }
        }

        @Override
        public void onHistorySevenDaysOfSportsReceived(@NonNull BluetoothDevice device, List<HistorySevenDaysOfSports> sports) {
            if (WearManager.this.mHistorySevenDaysOfSportsCallback != null) {
                WearManager.this.mHistorySevenDaysOfSportsCallback.onHistorySevenDaysOfSportsReceived(device, sports);
            }
        }

        @Override
        public void onHistoryOfHRRecordReceived(@NonNull BluetoothDevice device, List<Long> records) {
            if (WearManager.this.mHistoryOfHRRecordCallback != null) {
                WearManager.this.mHistoryOfHRRecordCallback.onHistoryOfHRRecordReceived(device, records);
            }
        }

        @Override
        public void onHistoryOfHRDataReceived(@NonNull BluetoothDevice device, List<HistoryOfHeartRate> heartRates) {
            if (WearManager.this.mHistoryOfHRDataCallback != null) {
                WearManager.this.mHistoryOfHRDataCallback.onHistoryOfHRDataReceived(device, heartRates);
            }
        }

        @Override
        public void onIntervalStepReceived(@NonNull BluetoothDevice device, List<IntervalStep> steps) {
            if (WearManager.this.mIntervalStepsCallback != null) {
                WearManager.this.mIntervalStepsCallback.onIntervalStepReceived(device, steps);
            }
        }

        @Override
        public void onSingleTapRecordReceived(@NonNull BluetoothDevice device, List<Long> records) {
            if (WearManager.this.mSingleTapRecordCallback != null) {
                WearManager.this.mSingleTapRecordCallback.onSingleTapRecordReceived(device, records);
            }
        }
    };

    public static synchronized WearManager getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new WearManager(context);
        }
        return mInstance;
    }

    private WearManager(Context context) {
        super(context);
        SpecManager.getInstance().setContext(context);
        SpecManager.getInstance().setWearManager(this);
    }

    @Override
    @NonNull
    protected BleManager.BleManagerGattCallback getGattCallback() {
        return new WearManagerGattCallback();
    }

    public void addBodySportCallback(BodySportCallback callback) {
        this.mBodySportCallback = callback;
    }

    public void addHeartRateMeasurementCallback(HeartRateMeasurementCallback callback) {
        this.mHeartRateMeasurementCallback = callback;
    }

    public void setBluetoothStatusCallback(BluetoothStatusCallback callback) {
        this.mBluetoothStatusCallback = callback;
    }

    public void addUserInfoCallback(UserInfoCallback callback) {
        this.mUserInfoCallback = callback;
    }

    public void addHistoryOfSportCallback(HistorySevenDaysOfSportsCallback callback) {
        this.mHistorySevenDaysOfSportsCallback = callback;
    }

    public void addHistoryOfHRRecordCallback(HistoryOfHRRecordCallback callback) {
        this.mHistoryOfHRRecordCallback = callback;
    }

    public void addHistoryOfHRDataCallback(HistoryOfHRDataCallback callback) {
        this.mHistoryOfHRDataCallback = callback;
    }

    public void addIntervalStepCallback(IntervalStepCallback callback) {
        this.mIntervalStepsCallback = callback;
    }

    public void addSingleTapRecordCallback(SingleTapRecordCallback callback) {
        this.mSingleTapRecordCallback = callback;
    }

    public void addSleepDataCallback(HistorySleepCallback callback) {
        this.historySleepCallback = callback;
    }

    public void addBloodOxygenCallback(BloodOxygenCallback callback) {
        this.bloodOxygenCallback = callback;
    }

    public void addTemperatureCallback(TemperatureCallback callback) {
        this.mTemperatureCallback = callback;
    }

    public void addVibrationIntensityCallback(VibrationIntensityCallback callback) {
        this.mVibrationIntensityCallback = callback;
    }

    public void addSportModeCallback(SportModeCallback callback) {
        this.mSportModeCallback = callback;
    }

    public void addWeatherStatusCallback(WeatherStatusCallback callback) {
        this.mWeatherStatusCallback = callback;
    }

    public void addHistoryBodyTemperatureCallback(HistoryBodyTemperatureCallback callback) {
        this.mHistoryBodyTemperatureCallback = callback;
    }

    public void addHistoryBloodOxygenCallback(HistoryBloodOxygenCallback callback) {
        this.mHistoryBloodOxygenCallback = callback;
    }

    public void addHistorySportsCallback(HistorySportsCallback callback) {
        this.mHistorySportsCallback = callback;
    }

    public void addBindDeviceCallback(BindDeviceCallback callback) {
        this.mBindDeviceCallback = callback;
    }

    public void addSpecificFunctionCallback(SpecificFunctionCallback callback) {
        this.mSpecificFunctionCallback = callback;
    }

    public void addSkippingRopeDataCallback(SkippingRopeDataCallback callback) {
        this.mSkippingRopeDataCallback = callback;
    }

    public void addHistorySkippingRopeCallback(HistorySkippingRopeCallback callback) {
        this.mHistorySkippingRopeCallback = callback;
    }

    public void addHeartRateThroughoutTheDayCallback(HeartRateThroughoutTheDayCallback callback) {
        this.mHeartRateThroughoutTheDayCallback = callback;
    }

    public void addSportsRealTimeDataCallback(SportsRealTimeDataCallback callback) {
        this.mSportsRealTimeDataCallback = callback;
    }

    public void addAccelerometerCallback(AccelerometerCallback callback) {
        this.mAccelerometerCallback = callback;
    }

    public void addPhysicalConditionCallback(PhysicalConditionCallback callback) {
        this.mPhysicalConditionCallback = callback;
    }

    public void addSportModeExitStatusCallback(SportModeExitStatusCallback callback) {
        this.mSportModeExitStatusCallback = callback;
    }

    public void addSensorRawDataCallback(SensorRawDataCallback callback) {
        this.mSensorRawDataCallback = callback;
    }

    public void addMACAddressCallback(MACAddressCallback callback) {
        this.mMacAddressCallback = callback;
    }

    public void addHistoryOfHealthDataCallback(HistoryOfHealthDataCallback callback) {
        this.mHistoryOfHealthDataCallback = callback;
    }

    public void addUserIdNameCallback(UserIdNameCallback callback) {
        this.mUserIdNameCallback = callback;
    }

    public void addMeasureModeStateCallback(MeasureModeStateCallback callback) {
        this.mMeasureModeStateCallback = callback;
    }

    public void addRespiratoryRateCallback(RespiratoryRateCallback callback) {
        this.mRespiratoryRateCallback = callback;
    }

    public void addHistoryOfHRDetailRecordCallback(HistoryOfHRDetailRecordCallback callback) {
        this.mHistoryOfHRDetailRecordCallback = callback;
    }

    public void addHistoryOfHRDetailDataCallback(HistoryOfHRDetailDataCallback callback) {
        this.mHistoryOfHRDetailDataCallback = callback;
    }

    public void addHeartRateMaxCallback(HeartRateMaxCallback callback) {
        this.mHeartRateMaxCallback = callback;
    }

    public void setFilterNames(String ... filterNames) {
        this.mFilterNames = filterNames;
    }

    public void startScan(FilterScanCallback callback) {
        this.mScanCallback = new WearScanCallback(callback);
        BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
        ScanSettings settings = new ScanSettings.Builder().setScanMode(2).setUseHardwareBatchingIfSupported(false).setReportDelay(1000L).setLegacy(false).build();
        ArrayList<ScanFilter> filters = new ArrayList<ScanFilter>();
        ParcelUuid uuid = new ParcelUuid(HR_SERVICE_UUID);
        filters.add(new ScanFilter.Builder().setServiceUuid(uuid).build());
        scanner.startScan(filters, settings, this.mScanCallback);
    }

    public void stopScan() {
        if (this.mScanCallback != null) {
            BluetoothLeScannerCompat scanner = BluetoothLeScannerCompat.getScanner();
            scanner.stopScan(this.mScanCallback);
        }
    }

    public void connectDevice(String macAddress) {
        BluetoothManager bluetoothManager = (BluetoothManager)this.getContext().getSystemService("bluetooth");
        BluetoothAdapter adapter = bluetoothManager.getAdapter();
        BluetoothDevice device = adapter.getRemoteDevice(macAddress);
        if (device != null) {
            this.connectDevice(device);
        }
    }

    private void sendCommand(byte cmd, byte ... values) {
        byte[] result;
        int unique = 4;
        if (values != null) {
            int len = values.length + 4;
            byte[] header = HexUtil.compose(255, len, cmd);
            byte[] bytes = HexUtil.compose(values);
            result = HexUtil.append(header, bytes);
        } else {
            result = HexUtil.compose(255, 4, cmd);
        }
        byte check = this.checkSum(result);
        byte[] command = HexUtil.append(result, check);
        this.writeTxCharacteristic(command);
    }

    public void setUTCTime() {
        this.setUTCTime(DateUtil.getZoneUTC());
    }

    public void setUTCTime(long stamp) {
        this.sendCommand((byte)8, this.utc2Bytes(stamp));
    }

    public void Restoration() {
        this.sendCommand((byte)-13, 0);
    }

    public void setBluetoothDisabled() {
        this.sendCommand((byte)63, 2);
    }

    public void getHistoryOfSport() {
        this.mReceivedDataCallback.clearType(2);
        this.sendCommand((byte)22, 0);
    }

    public void getHistoryOfHRRecord() {
        this.mReceivedDataCallback.clearType(4);
        this.sendCommand((byte)33, 0);
    }

    public void getHistoryOfHRData(long stamp) {
        this.mReceivedDataCallback.clearType(6);
        this.sendCommand((byte)34, HexUtil.append((byte)1, this.utc2Bytes(DateUtil.getZoneUTC(stamp))));
    }

    public void getIntervalSteps() {
        this.mReceivedDataCallback.clearType(8);
        this.sendCommand((byte)64, 0);
    }

    public void getSingleTapRecords() {
        this.mReceivedDataCallback.clearType(16);
        this.sendCommand((byte)66, 0);
    }

    public void getUserInfo() {
        this.sendCommand((byte)3, 0);
    }

    public void getSleepData() {
        this.mReceivedDataCallback.clearType(18);
        this.sendCommand((byte)5, 2);
    }

    public void getBodyTemperature() {
        this.sendCommand((byte)56, 0);
    }

    public void getBodyTemperatureHistory() {
        this.mReceivedDataCallback.clearType(20);
        this.sendCommand((byte)58, 0);
    }

    public void getBloodOxygenHistory() {
        this.mReceivedDataCallback.clearType(22);
        this.sendCommand((byte)57, 0);
    }

    public void getSportsHistory() {
        this.sendCommand((byte)59, 0);
    }

    public void getSevenDaysOfSkippingRopeHistorical() {
        this.sendCommand((byte)67, 0);
    }

    public void getHeartRateThroughoutTheDay() {
        this.sendCommand((byte)60, 0);
    }

    public void getHistoryOfHRDetailRecord() {
        this.mReceivedDataCallback.clearType(32);
        this.sendCommand((byte)116, 0, 32);
    }

    public void getHistoryOfHRDetailData(long stamp) {
        this.mReceivedDataCallback.clearType(34);
        this.sendCommand((byte)116, HexUtil.append(new byte[]{0, 33, 1}, this.utc2Bytes(DateUtil.getZoneUTC(stamp))));
    }

    public void getTheCurrentPhysicalCondition() {
        this.sendCommand((byte)117, 0, 11);
    }

    public void getDeviceMACAddress() {
        this.sendCommand((byte)117, 0, 13);
    }

    public void getHistoryOfHealthData(long begin) {
        this.mReceivedDataCallback.clearType(24);
        this.sendCommand((byte)-111, this.utc2Bytes(DateUtil.getZoneUTC(begin)));
    }

    public void setMeasurementMode(int mode) {
        this.sendCommand((byte)-110, (byte)mode);
    }

    public void exitMeasurementMode() {
        this.sendCommand((byte)-110, -1);
    }

    public void setUrl(String url) {
        this.sendCommand((byte)-109, HexUtil.append(new byte[]{(byte)url.length()}, HexUtil.stringToBytes(url)));
    }

    public boolean isValidName(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return HexUtil.encodingUTF8(name).length <= 15;
    }

    public void setUserIdName(long userId, String name) {
        byte[] names = HexUtil.encodingUTF8(name);
        byte[] heads = new byte[]{(byte)(userId >> 16 & 0xFFL), (byte)(userId >> 8 & 0xFFL), (byte)(userId & 0xFFL), (byte)names.length};
        this.sendCommand((byte)-108, HexUtil.append(heads, names));
    }

    public void getUserIdName() {
        this.sendCommand((byte)-107, new byte[0]);
    }

    public void setUserInfo(int age, int sex, int weight, int height, long userId) {
        byte[] command = new byte[]{(byte)age, (byte)sex, (byte)weight, (byte)height, (byte)(userId >> 32 & 0xFFL), (byte)(userId >> 24 & 0xFFL), (byte)(userId >> 16 & 0xFFL), (byte)(userId >> 8 & 0xFFL), (byte)(userId & 0xFFL)};
        this.sendCommand((byte)4, command);
    }

    public void setCallConfig(PhoneCallSpec call) {
        try {
            byte[] head = new byte[]{1, (byte)call.command};
            byte[] message = HexUtil.encodeString(call.getCall(), false);
            byte[] command = HexUtil.append(head, message);
            this.sendCommand((byte)7, command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setNotificationConfig(NotificationSpec notification) {
        try {
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(notification.stamp);
            String content = notification.title != null ? notification.title + ":" + notification.content : notification.content;
            if (content.length() > 60) {
                content = content.substring(59) + "...";
            }
            byte[] message = HexUtil.encodeString(content, false);
            int hour = calendar.get(11);
            int minute = calendar.get(12);
            byte[] header = new byte[]{2, 1, (byte)notification.type.key, (byte)hour, (byte)minute};
            byte[] command = HexUtil.append(header, message);
            this.sendCommand((byte)7, command);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setHeartRateMax(int max) {
        this.sendCommand((byte)116, 0, 6, (byte)max);
    }

    public void getHeartRateMax() {
        this.sendCommand((byte)117, 0, 6);
    }

    public void setVibrationIntensity(int vibration) {
        this.sendCommand((byte)11, (byte)vibration);
    }

    public void setSportMode(int mode) {
        this.sendCommand((byte)13, (byte)mode);
    }

    public void setSportModeExit(int state) {
        byte[] command = new byte[3];
        command[1] = 12;
        command[2] = (byte)state;
        this.sendCommand((byte)116, command);
    }

    public void exitSportMode() {
        this.sendCommand((byte)116, 0, 48);
    }

    public void removeHeartRateHistory() {
        this.sendCommand((byte)116, 0, 49);
    }

    public void setWeatherStatus(int weatherStatus, int current, int lowest, int highest, String timeZone) {
        byte[] msg_buf = timeZone.getBytes(StandardCharsets.UTF_8);
        byte[] command = new byte[14];
        if (weatherStatus == 0) {
            command[0] = 0;
        } else if (weatherStatus == 1) {
            command[0] = 1;
        } else if (weatherStatus == 2) {
            command[0] = 2;
        } else if (weatherStatus == 3) {
            command[0] = 3;
        } else if (weatherStatus == 4) {
            command[0] = 4;
        }
        command[1] = (byte)current;
        command[2] = (byte)lowest;
        command[3] = (byte)highest;
        int len = msg_buf.length;
        System.arraycopy(msg_buf, 0, command, 4, len);
        this.sendCommand((byte)10, command);
    }

    public void setSpecificFunctionSwitch(boolean raiseTheWrist, boolean sedentaryReminder) {
        int command = raiseTheWrist && sedentaryReminder ? 3 : (sedentaryReminder ? 2 : (raiseTheWrist ? 1 : 0));
        this.sendCommand((byte)14, (byte)command);
    }

    public void setSkippingSwitch(boolean skippingSwitch) {
        boolean command = skippingSwitch;
        this.sendCommand((byte)14, (byte)(command ? 1 : 0));
    }

    public void setCustomDataReceivedCallback(CustomDataReceivedCallback customDataReceivedCallback) {
        this.mCustomDataReceivedCallback = customDataReceivedCallback;
    }

    public void bind(String user) {
        this.bindAction((byte)0, user);
    }

    public void rebind(String user) {
        this.bindAction((byte)1, user);
    }

    public void unbind(String user) {
        this.bindAction((byte)2, user);
    }

    private void bindAction(byte mode, String user) {
        byte[] bytes = HexUtil.stringToBytes(user);
        byte[] value1 = HexUtil.append((byte)57, this.getDeviceId());
        byte[] value2 = HexUtil.append((byte)105, bytes);
        byte[] value = this.encode(HexUtil.append(value1, value2));
        byte[] command = HexUtil.append(mode, value);
        this.sendCommand((byte)16, command);
    }

    private byte[] encode(byte[] bytes) {
        byte code = (byte)(Math.random() * 1000.0);
        byte[] dest = new byte[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            dest[i] = (byte)(bytes[i] ^ code);
        }
        return dest;
    }

    private synchronized byte[] getDeviceId() {
        String[] names;
        byte[] deviceId = new byte[4];
        if (this.getBluetoothDevice() != null && (names = this.getBluetoothDevice().getName().split("-")).length > 1) {
            long id = Long.parseLong(names[names.length - 1]);
            deviceId[0] = (byte)(id >> 24 & 0xFFL);
            deviceId[1] = (byte)(id >> 16 & 0xFFL);
            deviceId[2] = (byte)(id >> 8 & 0xFFL);
            deviceId[3] = (byte)(id & 0xFFL);
            return deviceId;
        }
        return deviceId;
    }

    private final class WearManagerGattCallback
    extends FitnessManager.FitnessManagerGattCallback {
        private WearManagerGattCallback() {
            super(WearManager.this);
        }

        @Override
        protected void initialize() {
            super.initialize();
            WearManager.this.readCharacteristic(WearManager.this.mBodySensorLocationCharacteristic).with(WearManager.this.mBodySensorLocationDataCallback).fail((device, status) -> WearManager.this.log(5, "Body Sensor Location characteristic not found")).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mHeartRateCharacteristic).with(WearManager.this.mHeartRateMeasureDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mHeartRateCharacteristic).enqueue();
            WearManager.this.setNotificationCallback(WearManager.this.mRXCharacteristic).with(WearManager.this.mReceivedDataCallback);
            WearManager.this.enableNotifications(WearManager.this.mRXCharacteristic).done(device -> WearManager.this.log(3, "Rx notifications enabled")).fail((device, status) -> WearManager.this.log(5, "Rx characteristic not found")).enqueue();
            if (WearManager.this.mCustomRxCharacteristic != null) {
                WearManager.this.setNotificationCallback(WearManager.this.mCustomRxCharacteristic).with((device, data) -> {
                    if (WearManager.this.mCustomDataReceivedCallback != null) {
                        WearManager.this.mCustomDataReceivedCallback.onDataReceived(device, data.getValue());
                    }
                });
                WearManager.this.enableNotifications(WearManager.this.mCustomRxCharacteristic).enqueue();
            }
        }

        @Override
        public boolean isRequiredServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isRequiredServiceSupported(gatt);
            BluetoothGattService hrService = gatt.getService(HR_SERVICE_UUID);
            if (hrService != null) {
                WearManager.this.mHeartRateCharacteristic = hrService.getCharacteristic(HEART_RATE_MEASUREMENT_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mHeartRateCharacteristic != null;
        }

        @Override
        protected boolean isOptionalServiceSupported(@NonNull BluetoothGatt gatt) {
            super.isOptionalServiceSupported(gatt);
            BluetoothGattService service = gatt.getService(HR_SERVICE_UUID);
            if (service != null) {
                WearManager.this.mBodySensorLocationCharacteristic = service.getCharacteristic(BODY_SENSOR_LOCATION_CHARACTERISTIC_UUID);
            }
            return WearManager.this.mBodySensorLocationCharacteristic != null;
        }

        @Override
        protected void onDeviceReady() {
            super.onDeviceReady();
            WearManager.this.setUTCTime();
        }

        @Override
        protected void onDeviceDisconnected() {
            super.onDeviceDisconnected();
            WearManager.this.mBodySensorLocationCharacteristic = null;
            WearManager.this.mHeartRateCharacteristic = null;
        }

        @Override
        protected void onServicesInvalidated() {
            super.onServicesInvalidated();
            WearManager.this.mBodySensorLocationCharacteristic = null;
            WearManager.this.mHeartRateCharacteristic = null;
        }
    }

    private final class WearScanCallback
    extends ScanCallback {
        private final FilterScanCallback mCallback;

        private WearScanCallback(FilterScanCallback callback) {
            this.mCallback = callback;
        }

        private boolean matchDeviceName(BluetoothDevice device) {
            if (WearManager.this.mFilterNames != null) {
                if (device != null) {
                    String name = device.getName();
                    if (device.getName() != null && !TextUtils.isEmpty((CharSequence)device.getName())) {
                        for (String filterName : WearManager.this.mFilterNames) {
                            if (!name.contains(filterName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            return true;
        }

        @Override
        public void onScanResult(int callbackType, @NonNull ScanResult result) {
            super.onScanResult(callbackType, result);
            if (this.mCallback != null) {
                this.mCallback.onScanResult(callbackType, result);
            }
        }

        @Override
        public void onBatchScanResults(@NonNull List<ScanResult> results) {
            ArrayList<ScanResult> scanDevices = new ArrayList<ScanResult>();
            for (ScanResult result : results) {
                BluetoothDevice device = result.getDevice();
                if (!this.matchDeviceName(device)) continue;
                scanDevices.add(result);
            }
            if (this.mCallback != null) {
                this.mCallback.onBatchScanResults(results);
                this.mCallback.onFilterScanResults(scanDevices);
            }
        }

        @Override
        public void onScanFailed(int errorCode) {
            super.onScanFailed(errorCode);
            if (this.mCallback != null) {
                this.mCallback.onScanFailed(errorCode);
            }
        }
    }
}

